import 'package:viserpay_agent/core/utils/method.dart';
import 'package:viserpay_agent/core/utils/url_container.dart';
import 'package:viserpay_agent/data/model/global/response_model/response_model.dart';
import 'package:viserpay_agent/data/services/api_service.dart';

class TransactionRepo {
  ApiClient apiClient;
  TransactionRepo({required this.apiClient});

  Future<ResponseModel> getTransactionData(
    int page, {
    String searchText = "",
    String transactionType = "",
    String operationType = "",
    String historyFrom = "",
  }) async {
    Map<String, String> params = {};
    String type = "";
    String remark = "";
    String days = "";

    if (searchText.trim().isNotEmpty) {
      params['search'] = searchText;
    }
    if (transactionType.isNotEmpty && transactionType.toLowerCase() != "all type") {
      // params['type'] = transactionType;
      type = transactionType;
    }

    if (operationType.isNotEmpty && operationType.toLowerCase() != "all operations") {
      params['remark'] = operationType;
      remark = operationType;
    }

    if (historyFrom.isNotEmpty && historyFrom.toLowerCase() != "all time") {
      days = getOnlynumber(historyFrom);
    }

    String url = "${UrlContainer.baseUrl}${UrlContainer.transactionEndpoint}?page=$page&search=$searchText&type=$type&remark=$remark&days=$days";

    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, params, passHeader: true);
    return responseModel;
  }
}

String getOnlynumber(String time) {
  if (time.contains("days")) {
    return time.split("days")[0];
  } else if (time.contains("month")) {
    return (int.parse(time.split("month")[0]) * 30).toString();
  } else if (time.contains("year")) {
    return (int.parse(time.split("year")[0]) * 365).toString();
  }
  return "All Time";
}
